 ; Ŀ
 ;   Fifty - increment line numbers, update blocks and text to match.      
 ;   Copyright 2000 by Rocket Software                                     
 ;                                                                         
 ;   Might want to arrange so that incrementing starts at the last number  
 ;   and works backwards, and decrementing starts at the first and works   
 ;   forward.                                                              
 ;   Also make the maximum_string_length_to_modify an input.               
 ;                                                                         
 ;                                                                         
 ; 

 ; Ŀ
 ;   Ama - error handler.                                                  
 ; 
 (DEFUN AMA (shk)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Ama end.                                                              
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Chup - search and replace the strings in an ss of blocks and text.    
 ;   Arguments: Ss, the selection set.                                     
 ;              Cc, the original text string.                              
 ;              Dd, the replacement string.                                
 ;              Colo, the grdraw marker x colour.                          
 ;              Maxlen, the maximum string length to touch.                
 ;   Calls Chug.                                                           
 ;   Returns nothing.                                                      
 ;                                                                         
 ;   Blocks aren't touched if their names are present in the notouch       
 ;   list.  No string longer than 15 characters is changed.                
 ;                                                                         
 ; 
 (DEFUN CHUP (ss cc dd colo maxlen / notouch num enam typ entt txt altr
                                                         newtxt pa esub chg)
  (setq notouch (list "MAINTB" "REVTB" "PLOTDATE" "2WIREDEV" "3WIREDEV"
                      "4WIREDEV" "1771-IBD" "1771-OBD" "1771-IFE"
                      "1771-OFE" "1771-CFM" "3100-MCM" "1746-IB16"
                      "1746-OB16" "1746-NI4" "1746-NO4I" "GEIELCTB"
                      "TRMSTRIP" "WIRELINE" "D-BORD-E" "QDATT"))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
         (setq chg ())
         (cond ((= typ "TEXT")
                (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
                (setq altr (chug cc dd txt))
                (if (and (> (cadr altr) 0)      ; if any changes made
                         (< (strlen txt) maxlen))
                    (progn
                         (setq chg T)
                         (setq newtxt (car altr))
                         (setq pa (cdr (assoc 10 entt)))
                         (marc pa colo)
                         (entmod (subst (cons 1 newtxt)
                                        (assoc 1 entt) entt)))))
               ((and (= typ "INSERT")
                     (not (member (cdr (assoc 2 (entget enam))) notouch)))
                (setq esub (entnext enam))
                (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                       (setq txt (cdr (assoc 1 entt)))
                       (setq altr (chug cc dd txt))
                       (if (and (> (cadr altr) 0)  ; if any changes made
                                (< (strlen txt) maxlen))
                           (progn
                                (setq chg T)
                                (setq newtxt (car altr))
                                (setq pa (cdr (assoc 10 entt)))
                                (marc pa colo)
                                (entmod (subst (cons 1 newtxt)
                                               (assoc 1 entt) entt))))
                       (setq esub (entnext esub)))
                (if chg (entupd enam))))
         (if chg
             (ssdel enam ss)
             (setq num (1+ num))))
 (princ))
 ; Ŀ
 ;   Chup end.                                                             
 ; 

 ; Ŀ
 ;   Marc - draw a marker X at a point.                                    
 ; 
 (DEFUN MARC (pa col / rad)
  (setq rad (/ (getvar "viewsize") 25))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) col)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) col)
 (princ))
 ; Ŀ
 ;   Marc end.                                                             
 ; 

 ; Ŀ
 ;   Fifty.                                                                
 ; 
 (DEFUN C:FIFTY (/ sparam ss oldnum newnum incr colo)
  (setq esav *error*)
  (setq *error* ama)
 ; Ŀ
 ;   Get new and old numbers, calculate the increment.                     
 ; 
  (setq oldnum (getint "Current first line number: "))
  (setq newnum (getint "New first line number: "))
  (setq incr (- newnum oldnum))
 ; Ŀ
 ;   Get an ss of text and blocks with attributes.                         
 ; 
  (setq sparam '((-4 . "<or") (0 . "text")
                 (-4 . "<and") (0 . "insert") (66 . 1)
                 (-4 . "and>") (-4 . "or>")))
  (write-line "Select text-like objects to update or <Return> for all: ")
  (if (null (setq ss (ssget sparam)))
      (setq ss (ssget "x" sparam)))
 ; Ŀ
 ;   Search and replace the ss with each number in the sequence.           
 ; 
  (setq colo 1)
  (repeat 50
         (if (= colo 7)
             (setq colo 1)
             (setq colo (1+ colo)))
         (write-line (strcat (itoa oldnum) "/" (itoa newnum)))
         (chup ss (itoa oldnum) (itoa newnum) colo 15)
;         (print (sslength ss))
         (setq oldnum (1+ oldnum))
         (setq newnum (1+ newnum)))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (setq *error* esav)
 (princ))